<?php

/**
 * VGS Hide Ads Banner Module
 *
 *
 * @package        VGSHideAds Module
 * @author         Conrado Maggi - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

include_once 'modules/Vtiger/CRMEntity.php';
include_once 'include/utils/utils.php';

class VGSHideAds extends Vtiger_CRMEntity
{

    protected $moduleName = 'VGSHideAds';
    protected $settingsModLabel =  'Hide Dashboard Banner';
    protected $settingsIndexURL = 'index.php?module=VGSHideAds&view=IndexVGSHideAds&parent=Settings';


    public function __construct()
    {
    }

    

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type
     */
    function vtlib_handler($moduleName, $eventType)
    {
        if ($eventType == 'module.postinstall') {
            $this->addSettingsLinks();
        } elseif ($eventType == 'module.preuninstall') {
            $adb = PearDatabase::getInstance();
            $adb->pquery("DELETE FROM vtiger_settings_field WHERE name=?", array($this->settingsModLabel));
        } elseif ($eventType == 'module.preupdate') {
        } elseif ($eventType == 'module.postupdate') {
        } elseif ($eventType == 'module.disabled') {
             $adb = PearDatabase::getInstance();
            $adb->pquery("UPDATE vtiger_settings_field SET active=1 WHERE name=?", array($this->settingsModLabel));
        } elseif ($eventType == 'module.enabled') {
            $this->addSettingsLinks();
            $adb = PearDatabase::getInstance();
            $adb->pquery("UPDATE vtiger_settings_field SET active=0 WHERE name=?", array($this->settingsModLabel));
        }
    }

    function addSettingsLinks()
    {
        $adb = PearDatabase::getInstance();
        $otherSettingsBlock = $adb->pquery('SELECT * FROM vtiger_settings_blocks WHERE label=?', array('LBL_OTHER_SETTINGS'));
        $otherSettingsBlockCount = $adb->num_rows($otherSettingsBlock);

        if ($otherSettingsBlockCount > 0) {
            $blockid = $adb->query_result($otherSettingsBlock, 0, 'blockid');
            $sequenceResult = $adb->pquery("SELECT max(sequence) as sequence FROM vtiger_settings_blocks WHERE blockid=?", array($blockid));
            if ($adb->num_rows($sequenceResult)) {
                $sequence = $adb->query_result($sequenceResult, 0, 'sequence');
            }
        }

        $settingsFields = $adb->pquery('SELECT * FROM vtiger_settings_field WHERE name=?', array($this->settingsModLabel));
        $settingsFieldsCount = $adb->num_rows($settingsFields);
        if ($settingsFieldsCount == 0) {
                $fieldid = $adb->getUniqueID('vtiger_settings_field');
                $adb->pquery("INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence, active) 
                            VALUES(?,?,?,?,?,?,?,?)", array($fieldid, $blockid, $this->settingsModLabel, '', $this->moduleName, $this->settingsIndexURL, $sequence++, 0));
        }
    }
}
