<?php

/**
 * VGS Hide Ads Banner Module
 *
 *
 * @package        VGSHideAds Module
 * @author         Conrado Maggi - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */
class VGSHideAds_IndexVGSHideAds_View extends Settings_Vtiger_Index_View {

    public function process(Vtiger_Request $request) {

        $viewer = $this->getViewer($request);

        $viewer->assign('ENABLED', $this->VGSLinkExists());
        $viewer->view('IndexVGSHideAds.tpl', $request->getModule());
    }

    function VGSLinkExists() {
        include_once 'vtlib/Vtiger/Module.php';
        $extensionStoreModel = Vtiger_Module::getInstance('ExtensionStore');
        if($extensionStoreModel){
            
                    $db = PearDatabase::getInstance();
                    $result = $db->pquery('SELECT * FROM vtiger_links WHERE tabid=? AND linktype=? AND linklabel=?', Array($extensionStoreModel->getId(), 'HEADERSCRIPT', 'ExtensionStoreCommonHeaderScript'));
                    
                    if($result && $db->num_rows($result) > 0){
                        return '0';
                    }else{
                        return '1';
                    }
        }
        
        
    }

        /**
     * Function to get the list of Script models to be included
     * @param Vtiger_Request $request
     * @return <Array> - List of Vtiger_JsScript_Model instances
     */
     function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        require_once('vtlib/Vtiger/Link.php');
        
        include('vtigerversion.php');
        $version = explode('.', $vtiger_current_version)[0];
        
        if ($version > 6) {
             $jsFileNames = array(
                "layouts.v7.modules.VGSHideAds.resources.VGSHideAds",
            );
        }else{
             $jsFileNames = array(
                "layouts.vlayout.modules.VGSHideAds.resources.VGSHideAds",
            );
        }    

       

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

}
